//
//  GSFontInfoProperty.h
//  GlyphsCore
//
//  Created by Georg Seifert on 06.04.19.
//  Copyright © 2019 schriftgestaltung.de. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <GlyphsCore/GSBase.h>
#import <GlyphsCore/GSContainerProtocol.h>
NS_ASSUME_NONNULL_BEGIN

@class GSCustomParameter;

@interface GSFontInfoProperty : NSObject <NSCopying> {
	__weak GSContainer *_parent;
	NSString *_value;

#pragma GSAutoCodeStart ivars

	NSString *_key;

#pragma GSAutoCodeEnd ivars
}

@property (nonatomic, weak) GSContainer *parent;

@property (nonatomic, copy) NSString *value;

- (nullable NSString *)defaultValue;

- (instancetype)initWithKey:(NSString *)key
					  value:(NSString *)value;

- (instancetype)initWithDict:(NSDictionary *)dict
					  format:(GSFormatVersion)formatVersion;

- (NSDictionary *)propertyListValueFormat:(GSFormatVersion)format;

#ifndef GLYPHS_VIEWER
- (BOOL)saveToFile:(FILE *)file
			format:(GSFormatVersion)formatVersion
			 error:(NSError **)error;

@property (nonatomic, readonly, nullable) NSUndoManager *undoManager;

@property (nonatomic, readonly, nullable) NSUndoManager *undoManagerCheck;

- (NSSet *)legacyDefaultKeys;

- (nullable NSArray<GSCustomParameter *> *)legacyCustomParameters;

#endif

#pragma GSAutoCodeStart methods

/// The key.
@property (nonatomic, strong) NSString *key;

#pragma GSAutoCodeEnd methods

@end

NS_ASSUME_NONNULL_END
